use strict;
use warnings;
use ExtUtils::MakeMaker;
use Alien::Build::MM;

my $abmm = Alien::Build::MM->new;

WriteMakefile($abmm->mm_args(
    NAME             => 'Alien::libpq',
    DISTNAME         => 'Alien-libpq',
    VERSION_FROM     => 'lib/Alien/libpq.pm',
    ABSTRACT         => 'Find or build libpq PostgreSQL client library',
    AUTHOR           => 'vividsnow',
    LICENSE          => 'perl_5',
    MIN_PERL_VERSION => '5.010',

    CONFIGURE_REQUIRES => {
        'Alien::Build::MM' => 0,
    },
    BUILD_REQUIRES => {
        'Alien::Build::MM' => 0,
    },
    PREREQ_PM => {
        'Alien::Base' => 0,
    },
    TEST_REQUIRES => {
        'Test::More'  => 0,
        'Test::Alien' => 0,
    },

    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url  => 'https://github.com/vividsnow/perl5-alien-libpq.git',
                web  => 'https://github.com/vividsnow/perl5-alien-libpq',
            },
        },
        provides => {
            'Alien::libpq' => {
                file    => 'lib/Alien/libpq.pm',
                version => '0.01',
            },
        },
    },
));

sub MY::postamble {
    $abmm->mm_postamble;
}
